/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.preprocessor;

import com.inprise.vbroker.compiler.preprocessor.ConditionalInfo;
import com.inprise.vbroker.compiler.preprocessor.Macro;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;

final class OpenStream {
    static final int MAXIMUM_BUFFER_SIZE = 0x100000;
    OpenStream PreviousStream;
    InputStream Stream;
    byte[] Buffer;
    int Length;
    int Index;
    long LineNumber;
    String FileName;
    String Directory;
    Macro Macro = null;
    boolean EndedWithLineSep = false;
    private Stack ConditionalStack = null;

    OpenStream(InputStream stream, String fileName, String directory, int lengthGuess) throws IOException {
        this.PreviousStream = null;
        this.Stream = stream;
        this.FileName = fileName;
        this.Directory = directory;
        this.LineNumber = 1L;
        this.Length = 0;
        this.Buffer = lengthGuess >= 0 && lengthGuess < 0x100000 ? new byte[lengthGuess] : new byte[0x100000];
        this.reload();
    }

    OpenStream(byte[] source, OpenStream currentStream, Macro macro) throws IOException {
        this.PreviousStream = currentStream;
        this.FileName = currentStream.FileName;
        this.Directory = currentStream.Directory;
        this.LineNumber = currentStream.LineNumber;
        this.Macro = macro;
        if (0x100000 >= source.length) {
            this.Stream = null;
            this.Buffer = source;
            this.Length = this.Buffer.length;
        } else {
            this.Stream = new ByteArrayInputStream(source);
            this.Buffer = new byte[0x100000];
            this.Length = 0;
            this.reload();
        }
    }

    boolean advance() throws IOException {
        if (this.Index == this.Length) {
            return this.reload();
        }
        ++this.Index;
        return true;
    }

    boolean conditionalStackEmpty() {
        return this.ConditionalStack == null;
    }

    byte conditionalStackPeek() {
        return ((ConditionalInfo)this.ConditionalStack.peek()).Status;
    }

    ConditionalInfo conditionalStackPeekEntry() {
        return (ConditionalInfo)this.ConditionalStack.peek();
    }

    ConditionalInfo conditionalStackPop() {
        ConditionalInfo ret = (ConditionalInfo)this.ConditionalStack.pop();
        if (this.ConditionalStack.empty()) {
            this.ConditionalStack = null;
        }
        return ret;
    }

    void finished() throws IOException {
        if (this.Stream != null) {
            this.Stream.close();
        }
    }

    boolean isTransient() {
        return this.PreviousStream != null;
    }

    ConditionalInfo[] openConditionals() {
        if (this.conditionalStackEmpty()) {
            return null;
        }
        ConditionalInfo[] ret = new ConditionalInfo[this.ConditionalStack.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (ConditionalInfo)this.ConditionalStack.pop();
        }
        return ret;
    }

    boolean reload() throws IOException {
        if (this.Stream == null) {
            return false;
        }
        this.Length = this.Stream.read(this.Buffer);
        if (this.Length <= 0) {
            this.Index = this.Length;
            return false;
        }
        this.Index = 0;
        return true;
    }

    boolean updateConditionalStack(ConditionalInfo info, byte newStatus) throws IOException {
        if (newStatus == 2 && !this.conditionalStackEmpty() && this.conditionalStackPeek() != 2) {
            newStatus = 1;
        }
        if (this.ConditionalStack == null) {
            this.ConditionalStack = new Stack();
        }
        this.ConditionalStack.push(new ConditionalInfo(info.Type, info.LineNumber, newStatus));
        return newStatus == 2;
    }

    boolean updateConditionalStack(String type, byte newStatus) throws IOException {
        if (newStatus == 2 && !this.conditionalStackEmpty() && this.conditionalStackPeek() != 2) {
            newStatus = 1;
        }
        if (this.ConditionalStack == null) {
            this.ConditionalStack = new Stack();
        }
        this.ConditionalStack.push(new ConditionalInfo(type, this.LineNumber, newStatus));
        return newStatus == 2;
    }
}

